define(['angular', 'app', 'TrackersFHIRService'], function (angular, app) {
    'use strict';

    app.service('WeightFHIRService', function (TrackersFHIRService) {
        var emptyWeightResource = {
            meta: {
                tag: [
                    {
                        'system': 'https://wiki.mobilehealth.DOMAIN.EXT/display/PGDMS/Client+Provenance+Mapping',
                        'code': 'REDACTED',
                        'display': 'VA FitHeart'
                    }
                ]
            },
            code: {coding: [{system: 'http://loinc.org', code: '29463-7', display: 'Body weight'}]},
            valueQuantity: {
                unit: 'pounds'
            }
        };

        return angular.extend({}, angular.copy(TrackersFHIRService), {
            code: 'http://loinc.org|29463-7',
            supportsLatest: true,

            createEmpty: function () {
                var emptyResource = angular.copy(emptyWeightResource);

                return angular.extend({}, TrackersFHIRService.createEmpty(), emptyResource);
            }
        });
    });
});